/**
* \file: partition_metadata.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_MODEL_PARTITION_METADATA_H
#define AAM_MODEL_PARTITION_METADATA_H

#include <stdlib.h>
#include <stdbool.h>

#include "model/partition.h"

// metadata structures might be extended by additional attributes by certain backends. partition_metadata_flexible_new
// can be used to create such an extended metadata structure. A special "free" function must be passed which is used by
// partition_metadata_free to remove the metadata structure from the memory.

// The definition  of a function used by partition_metadata_free to remove the metadata structure from memory.
typedef void (*partition_metadata_free_func_t)(partition_metadata_t *metadata);

//creates a minimal metadata structure
partition_metadata_t *partition_metadata_new(const char *identifier,
		const char *mountsrc, const char *mountfs, int partition_no);

//creates an extended metadata structure
partition_metadata_t *partition_metadata_flexible_new(const char *identifier,
		const char *mountsrc, const char *mountfs, int partition_no,
		size_t metadata_size, partition_metadata_free_func_t free_func);

// removes minimal as well as extended metadata structures from memory
void partition_metadata_free(partition_t *partition);

//get functions for the attributes contained in the minimal metadata structure
const char *partition_metadata_get_partition_identifier(partition_t *partition);

const char *partition_metadata_get_mountsrc(partition_t *partition);

const char *partition_metadata_get_mountfs(partition_t *partition);

int partition_metadata_get_partition_number(partition_t *partition);

#endif
